<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">


    <!-- PAGE TITLE HERE -->
    <title>الخبير الإداري ,تدريب واستشارات |تسجيل</title>

    <!-- FAVICONS ICON -->
    {{-- <link rel="shortcut icon" type="image/png" href="images/favicon.png" /> --}}
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    <link href="{{ asset('/css/toastr/toastr.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('/css/login.css') }}" rel="stylesheet">

</head>


<body class="vh-100">
    <section class="ftco-section">
        <div class="container">

            <div class="row justify-content-center">
                <div class="col-md-12 col-lg-10">
                    <div class="wrap d-md-flex">
                        <div class="img" style="background-image: url({{ asset('/images/login1.jpg') }});">
                        </div>
                        <div class="login-wrap p-4 p-md-5">
                            <div class="d-flex">
                                <div class="w-100 text-center">
                                    <h3 class="mb-4">اعادة تعيين كلمة المرور</h3>
                                </div>
                            </div>
                            @if (session()->has('error'))
                                <div class="alert alert-danger alert-dismissible bg-danger text-white border-0 fade show"
                                    role="alert">
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                    <strong style="margin-right: 50px;"
                                        id="errorm">{{ session()->get('error') }}</strong>
                                </div>
                            @endif
                            @error('email')
                                <div class="alert alert-danger alert-dismissible bg-danger text-white border-0 fade show"
                                    role="alert">
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                    <strong style="margin-right: 50px;" id="errorm">{{ $message }}</strong>
                                </div>
                            @enderror

                            <form class="signin-form" action="{{ route('resetPassword') }}" method="POST">
                                @csrf
                                <input type="hidden" name="email" value="{{ Auth::user()->email }}">

                                <div class="form-group mb-3">
                                    <label class="label" for="name">البريد الالكتروني</label>
                                    <input type="email" name="email" placeholder="ادخل بريدك الالكتروني"
                                        class="form-control" value="{{ Auth::user()->email }}" required autofocus>
                                    @error('newemail')
                                        <span style="color: #a31e23;font-size: 14px " class="" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                @if(Auth::user()->role == 2)
                                <div class="form-group mb-3">
                                    <label class="form-label" for="nameCertificate">الاسم المطلوب للشهادة</label>
                                    <input type="text" id="validationCustom01" value="{{ Auth::user()->certificate_name }}"
                                        name="nameCertificate" class="form-control text"
                                        placeholder="الرجاء ادخال الاسم المطلوب للشهادة" >
                                    <p id="alert" class="massege"></p>
                                    <div class="fv-plugins-message-container invalid-feedback ">
                                        "الرجاء ادخال الاسم المطلوب للشهادة </div>
                                    @error('nameCertificate')
                                        <div class="text-danger px-2 showModalAdd ">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                                @endif
                                <div class="form-group mb-3">
                                    <label class="label" for="password">كلمة المرور الجديدة</label>
                                    <input type="password" class="form-control"
                                        value="{{ old('password') }}" type="password" name="password"
                                        id="password" placeholder="ادخل كلمة المرور الجديدة هنا" required>
                                    @error('password')
                                        <span style="color: #a31e23;font-size: 14px " class="" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group mb-3">
                                    <label class="label" for="password">تأكيد كلمة المرور مرة اخرى</label>
                                    <input type="password" class="form-control"
                                        value="{{ old('password_confirmation') }}"
                                        type="password" name="password_confirmation" id="password"
                                        placeholder="ادخل كلمة المرور الجديدة مرة اخرى هنا" required>
                                    @error('password_confirmation')
                                        <span class="" style="color: #a31e23;font-size: 14px " role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <button type="submit"
                                        class="form-control btn btn-primary rounded submit px-3 text-center">تسجيل</button>
                                </div>
                                <div class="row  mb-2">
                                    <div class="custom-control custom-checkbox custom-control-inline">
                                        <input id="chk1" type="checkbox" name="chk"
                                            class="custom-control-input" style="width: auto">
                                        {{-- <label for="chk1" class="custom-control-label text-sm me-2">تذكرني
                                            لاحقاً</label> --}}
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>







    <!--**********************************
        Scripts
    ***********************************-->
    <!-- Required vendors -->
    <script src="{{ asset('/vendor/global/global.min.js') }}"></script>

    <!-- Toastr -->
    <script src="{{ asset('/js/toastr/toastr.min.js') }}"></script>

    <!-- All init script -->
    <script src="{{ asset('/js/toastr/toastr-init.js') }}"></script>


    <script src="{{ asset('/js/custom.min.js ') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js ') }}"></script>


</body>

</html>
